package com.xforceplus.bi.commons.resourcecode.service;

import com.xforceplus.bi.commons.integration.user.utils.RequestUserContext;
import com.xforceplus.bi.commons.resourcecode.dao.ResourceCodeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ResourceCodeServiceImpl implements ResourceCodeService {
    @Autowired
    private ResourceCodeDao resourceCodeDao;

    @Override
    public void insertResourceCode(String resourceCode, String resourceName) {
        validateResourceCodeUnique(resourceCode);
        resourceCodeDao.insertResourceCode(resourceCode, resourceName, RequestUserContext.get().getTenantId(), true);
    }

    @Override
    public void deleteResourceCode(String resourceCode) {
        resourceCodeDao.deleteResourceCode(resourceCode, RequestUserContext.get().getTenantId());
    }

    @Override
    public void validateResourceCodeUnique(String resourceCode) {
        Integer resourceCodeExists = resourceCodeDao.resourceCodeExists(resourceCode);
        Assert.isNull(resourceCodeExists, "此资源码(" + resourceCode + ")已存在,请重新输入");
    }

    @Override
    public void saveResourceCode(String newResourceCode, String oldResourceCode, String resourceName) {
        if (!newResourceCode.equals(oldResourceCode)) {
            // 更改资源码时,需要校验新资源码必须是不存在的
            validateResourceCodeUnique(newResourceCode);
            // 删除以前的资源码
            resourceCodeDao.deleteResourceCode(oldResourceCode, RequestUserContext.get().getTenantId());
            // 新增新的资源码
            resourceCodeDao.insertResourceCode(newResourceCode, resourceName, RequestUserContext.get().getTenantId(), true);
        } else {
            // 资源码不变,更新资源码名称
            resourceCodeDao.updateResourceCodeName(newResourceCode, resourceName, RequestUserContext.get().getTenantId());
        }
    }
}
