/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.sqlparser.clauses.utils;

import com.google.common.collect.Lists;
import com.xforceplus.bi.commons.sqlparser.clauses.beans.ConditionBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.collections4.CollectionUtils;

public class ConditionUtils {
    public static String appendConditions(String originSQL, List<ConditionBean> conditionBeans) throws JSQLParserException {
        Select select = (Select)CCJSqlParserUtil.parse((String)originSQL);
        PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
        ConditionUtils.append(plainSelect, conditionBeans);
        return select.toString();
    }

    private static void append(PlainSelect plainSelect, List<ConditionBean> conditionBeans) throws JSQLParserException {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            ArrayList tables = Lists.newArrayList();
            Table table = (Table)fromItem;
            tables.add(table.getName());
            List joins = plainSelect.getJoins();
            if (CollectionUtils.isNotEmpty((Collection)joins)) {
                for (Join join : joins) {
                    FromItem joinItem = join.getRightItem();
                    if (joinItem instanceof Table) {
                        System.out.println("JOIN\u662f\u4e00\u4e2a\u8868");
                        Table joinTable = (Table)joinItem;
                        tables.add(joinTable.getName());
                        continue;
                    }
                    if (!(joinItem instanceof SubSelect)) continue;
                    System.out.println("JOIN\u662f\u4e00\u4e2a\u5b50\u67e5\u8be2");
                    SubSelect subSelect = (SubSelect)joinItem;
                    PlainSelect joinPlainSelect = (PlainSelect)subSelect.getSelectBody();
                    ConditionUtils.append(joinPlainSelect, conditionBeans);
                }
            }
            for (ConditionBean conditionBean : conditionBeans) {
                if (!tables.contains(conditionBean.getConditionOnTable())) continue;
                ConditionUtils.appendSingle(plainSelect, conditionBean.getCondition());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            PlainSelect subPlainSelect = (PlainSelect)subSelect.getSelectBody();
            ConditionUtils.append(subPlainSelect, conditionBeans);
        }
    }

    private static void appendSingle(PlainSelect plainSelect, String permission) throws JSQLParserException {
        Expression condition = CCJSqlParserUtil.parseCondExpression((String)permission);
        Expression originCondition = plainSelect.getWhere();
        if (originCondition == null) {
            plainSelect.setWhere(condition);
        } else {
            AndExpression andExpression = new AndExpression(originCondition, condition);
            plainSelect.setWhere((Expression)andExpression);
        }
    }
}

