/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.sql.parser.service.impl;

import com.google.common.collect.Lists;
import com.xforceplus.bi.commons.sql.parser.beans.DataBaseBean;
import com.xforceplus.bi.commons.sql.parser.beans.QueryFilterBean;
import com.xforceplus.bi.commons.sql.parser.beans.QueryFilterGroupBean;
import com.xforceplus.bi.commons.sql.parser.beans.QueryFilterRangeBean;
import com.xforceplus.bi.commons.sql.parser.beans.QueryJoinBean;
import com.xforceplus.bi.commons.sql.parser.beans.QueryOrderBean;
import com.xforceplus.bi.commons.sql.parser.beans.QueryPageBean;
import com.xforceplus.bi.commons.sql.parser.beans.QuerySelectBean;
import com.xforceplus.bi.commons.sql.parser.service.SqlBuilderService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.SelectGroupByStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectLimitStep;
import org.jooq.SelectOptionStep;
import org.jooq.SelectOrderByStep;
import org.jooq.SelectSelectStep;
import org.jooq.SelectWhereStep;
import org.jooq.SortField;
import org.jooq.conf.ParamType;
import org.jooq.conf.Settings;
import org.jooq.conf.StatementType;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SqlBuilderServiceImpl
implements SqlBuilderService {
    private static final Logger log = LoggerFactory.getLogger(SqlBuilderServiceImpl.class);
    private static final String COUNT_SQL = "SELECT COUNT(1) FROM (%s) AS FOO";

    private SelectLimitStep getSelectOptionStep(DataBaseBean dataBaseBean, String from, List<QuerySelectBean> querySelectBeans, List<QueryJoinBean> queryJoinBeans, List<String> queryGroupBeans, List<QueryFilterGroupBean> queryFilterBeans, List<String> notNullFields, List<QueryOrderBean> queryOrderBeans) {
        SelectSelectStep<Record> selectSelectStep = null;
        selectSelectStep = this.selectFields(dataBaseBean, querySelectBeans);
        SelectJoinStep selectJoinStep = selectSelectStep.from(from);
        SelectWhereStep selectWhereStep = this.selectJoinStep(selectJoinStep, queryJoinBeans);
        SelectGroupByStep selectGroupByStep = this.selectWhereSetp(selectWhereStep, queryFilterBeans, notNullFields);
        SelectOrderByStep selectOrderByStep = this.selectGroupSetp(selectGroupByStep, queryGroupBeans);
        return this.selectOrderSetp(selectOrderByStep, queryOrderBeans);
    }

    @Override
    public String sqlBuilder(String from, List<QuerySelectBean> querySelectBeans, List<QueryJoinBean> queryJoinBeans, List<String> queryGroupBeans, List<QueryFilterGroupBean> queryFilterBeans, List<String> notNullFields, List<QueryOrderBean> queryOrderBeans, QueryPageBean queryPageBean, DataBaseBean dataBaseBean) {
        SelectLimitStep selectLimitStep = this.getSelectOptionStep(dataBaseBean, from, querySelectBeans, queryJoinBeans, queryGroupBeans, queryFilterBeans, notNullFields, queryOrderBeans);
        SelectOptionStep selectOptionStep = this.selectLimitStep(selectLimitStep, queryPageBean);
        return selectOptionStep.getSQL(ParamType.INLINED);
    }

    private SelectOptionStep selectLimitStep(SelectLimitStep selectLimitStep, QueryPageBean queryPageBean) {
        if (queryPageBean != null) {
            int offset = queryPageBean.getPageSize() * queryPageBean.getPageNum() - queryPageBean.getPageSize();
            offset = offset > 0 ? offset : 0;
            return selectLimitStep.limit(queryPageBean.getPageSize()).offset(offset);
        }
        return selectLimitStep;
    }

    private SelectLimitStep selectOrderSetp(SelectOrderByStep selectOrderByStep, List<QueryOrderBean> queryOrderBeans) {
        if (CollectionUtils.isEmpty(queryOrderBeans)) {
            return selectOrderByStep;
        }
        ArrayList orderFields = Lists.newArrayList();
        for (QueryOrderBean queryOrderBean : queryOrderBeans) {
            SortField sortField = "asc".equalsIgnoreCase(queryOrderBean.getType()) ? DSL.field((String)queryOrderBean.getIndex()).asc() : DSL.field((String)queryOrderBean.getIndex()).desc();
            orderFields.add(sortField);
        }
        return selectOrderByStep.orderBy((Collection)orderFields);
    }

    private SelectOrderByStep selectGroupSetp(SelectGroupByStep selectGroupByStep, List<String> queryGroupBeans) {
        if (CollectionUtils.isEmpty(queryGroupBeans)) {
            return selectGroupByStep;
        }
        ArrayList groupField = Lists.newArrayList();
        for (String queryGroupBean : queryGroupBeans) {
            groupField.add(DSL.field((String)queryGroupBean));
        }
        return selectGroupByStep.groupBy((Collection)groupField);
    }

    private SelectGroupByStep selectWhereSetp(SelectWhereStep selectWhereStep, List<QueryFilterGroupBean> queryFilterBeans, List<String> notNullFields) {
        List<Condition> conditionList = this.getAllCondition(queryFilterBeans);
        if (!CollectionUtils.isEmpty(notNullFields)) {
            notNullFields.forEach(item -> conditionList.add(DSL.field((String)item).isNotNull()));
        }
        if (CollectionUtils.isEmpty(conditionList)) {
            return selectWhereStep;
        }
        return selectWhereStep.where(conditionList);
    }

    private List<Condition> getAllCondition(List<QueryFilterGroupBean> queryFilterBeans) {
        ArrayList conditionList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(queryFilterBeans)) {
            return conditionList;
        }
        for (QueryFilterGroupBean filterGroupBean : queryFilterBeans) {
            List<QueryFilterBean> queryFilterBeans1 = filterGroupBean.getQueryFilterBeans();
            if (CollectionUtils.isEmpty(queryFilterBeans1)) continue;
            Condition condition = this.getCondition(queryFilterBeans1);
            conditionList.add(condition);
        }
        return conditionList;
    }

    private Condition getCondition(List<QueryFilterBean> queryFilterBeans) {
        Condition condition = null;
        for (QueryFilterBean queryFilterBean : queryFilterBeans) {
            Field field = DSL.field((String)queryFilterBean.getField());
            Condition conditionTemp = null;
            if (!CollectionUtils.isEmpty(queryFilterBean.getValues())) {
                Condition condition2 = conditionTemp = queryFilterBean.getValues().size() == 1 ? field.equal(queryFilterBean.getValues().get(0)) : field.in(queryFilterBean.getValues());
            }
            if (!CollectionUtils.isEmpty(queryFilterBean.getRanges())) {
                for (QueryFilterRangeBean item : queryFilterBean.getRanges()) {
                    Condition filterCondition = null;
                    if (this.notEmpty(item.getStart())) {
                        filterCondition = field.greaterOrEqual(item.getStart());
                    }
                    if (this.notEmpty(item.getEnd())) {
                        Condition condition3 = filterCondition = filterCondition == null ? field.lessOrEqual(item.getEnd()) : filterCondition.and(field.lessOrEqual(item.getEnd()));
                    }
                    if (conditionTemp == null) {
                        conditionTemp = filterCondition;
                        continue;
                    }
                    if (filterCondition == null) continue;
                    conditionTemp = conditionTemp.or(filterCondition);
                }
            }
            if (CollectionUtils.isEmpty(queryFilterBean.getValues()) && CollectionUtils.isEmpty(queryFilterBean.getRanges())) {
                conditionTemp = field.isNull();
            }
            if (condition == null) {
                condition = conditionTemp;
                continue;
            }
            condition = condition.or(conditionTemp);
        }
        return condition;
    }

    private boolean notEmpty(Object obj) {
        return obj != null && !"".equals(obj);
    }

    private SelectWhereStep selectJoinStep(SelectJoinStep selectJoinStep, List<QueryJoinBean> list) {
        if (CollectionUtils.isEmpty(list)) {
            return selectJoinStep;
        }
        for (QueryJoinBean queryJoinBean : list) {
            switch (queryJoinBean.getType().toLowerCase()) {
                case "left join": {
                    selectJoinStep = selectJoinStep.leftJoin(queryJoinBean.getTable()).on(this.condition(queryJoinBean.getConditions()));
                    break;
                }
                case "right join": {
                    selectJoinStep = selectJoinStep.rightJoin(queryJoinBean.getTable()).on(this.condition(queryJoinBean.getConditions()));
                    break;
                }
                case "inner join": {
                    selectJoinStep = selectJoinStep.innerJoin(queryJoinBean.getTable()).on(this.condition(queryJoinBean.getConditions()));
                }
            }
        }
        return selectJoinStep;
    }

    private Condition condition(List<QueryJoinBean.Condition> conditionList) {
        Condition condition = null;
        for (QueryJoinBean.Condition condition1 : conditionList) {
            Condition conditionTemp = DSL.field((String)condition1.getJoinField()).eq(DSL.field((String)condition1.getFromField()));
            condition = condition == null ? conditionTemp : condition.and(conditionTemp);
        }
        return condition;
    }

    private SelectSelectStep<Record> selectFields(DataBaseBean dataBaseBean, List<QuerySelectBean> querySelectBeans) {
        ArrayList selectFields = Lists.newArrayList();
        for (QuerySelectBean item : querySelectBeans) {
            Field field = DSL.field((String)item.getField());
            if (StringUtils.isNotBlank((CharSequence)item.getAlias())) {
                field = field.as(item.getAlias());
            }
            selectFields.add(field);
        }
        DSLContext dslContext = this.getDslContext(dataBaseBean);
        return dslContext.select((Collection)selectFields);
    }

    private DSLContext getDslContext(DataBaseBean dataBaseBean) {
        Settings settings = new Settings();
        settings.setParamType(ParamType.INLINED);
        settings.setStatementType(StatementType.STATIC_STATEMENT);
        String jdbcDbDialect = dataBaseBean.getJdbcDbDialect();
        SQLDialect sqlDialect = null;
        if (StringUtils.isNotEmpty((CharSequence)jdbcDbDialect)) {
            try {
                sqlDialect = SQLDialect.valueOf((String)jdbcDbDialect);
            }
            catch (Exception e) {
                log.warn("\u672a\u77e5\u7684\u65b9\u8a00({}), \u4f7f\u7528\u9ed8\u8ba4\u65b9\u8a00", (Object)jdbcDbDialect);
            }
        }
        if (sqlDialect == null) {
            sqlDialect = SQLDialect.DEFAULT;
        }
        return DSL.using((SQLDialect)sqlDialect, (Settings)settings);
    }

    @Override
    public String dataSql(String from, List<QuerySelectBean> querySelectBeans, List<QueryJoinBean> queryJoinBeans, List<String> queryGroupBeans, List<QueryFilterGroupBean> queryFilterBeans, List<String> notNullFields, List<QueryOrderBean> queryOrderBeans, QueryPageBean queryPageBean, DataBaseBean dataBaseBean) {
        return this.sqlBuilder(from, querySelectBeans, queryJoinBeans, queryGroupBeans, queryFilterBeans, notNullFields, queryOrderBeans, queryPageBean, dataBaseBean);
    }

    @Override
    public String countSql(String from, List<QuerySelectBean> querySelectBeans, List<QueryJoinBean> queryJoinBeans, List<String> queryGroupBeans, List<QueryFilterGroupBean> queryFilterBeans, List<String> notNullFields, List<QueryOrderBean> queryOrderBeans, DataBaseBean dataBaseBean) {
        SelectLimitStep selectLimitStep = this.getSelectOptionStep(dataBaseBean, from, querySelectBeans, queryJoinBeans, queryGroupBeans, queryFilterBeans, notNullFields, queryOrderBeans);
        return String.format(COUNT_SQL, selectLimitStep.getSQL());
    }

    @Override
    public String summarySql(String from, List<QuerySelectBean> querySelectBeans, List<QueryJoinBean> queryJoinBeans, List<String> queryGroupBeans, List<QueryFilterGroupBean> queryFilterBeans, List<String> notNullFields, List<QueryOrderBean> queryOrderBeans, DataBaseBean dataBaseBean) {
        return this.sqlBuilder(from, querySelectBeans, queryJoinBeans, queryGroupBeans, queryFilterBeans, notNullFields, queryOrderBeans, null, dataBaseBean);
    }
}

