/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.zookeeper;

import com.xforceplus.bi.commons.zookeeper.ZookeeperNodeUpdateListener;
import java.text.MessageFormat;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.data.Stat;

public class ZookeeperClient {
    private static volatile ZookeeperClient INSTANCE;
    private static volatile CuratorFramework curator;

    private ZookeeperClient(String zkServer) {
        curator = CuratorFrameworkFactory.builder().connectString(zkServer).sessionTimeoutMs(10000).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 5)).build();
        curator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZookeeperClient getInstance(String zkServer) {
        if (INSTANCE != null) return INSTANCE;
        Class<ZookeeperClient> clazz = ZookeeperClient.class;
        synchronized (ZookeeperClient.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ZookeeperClient(zkServer);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void createNodeDeeplyIfNotExists(String nodePath) {
        Stat exists = this.exists(nodePath);
        if (exists == null) {
            this.createPersistentNode(nodePath, "");
        }
    }

    private String createPersistentNode(String nodePath, String nodeValue) {
        try {
            return (String)curator.create().creatingParentsIfNeeded().forPath(nodePath, nodeValue.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u8282\u70b9\u65f6\u53d1\u751f\u5f02\u5e38 ", e);
        }
    }

    public Stat exists(String nodePath) {
        try {
            return (Stat)curator.checkExists().forPath(nodePath);
        }
        catch (Exception e) {
            throw new RuntimeException("\u68c0\u67e5\u8def\u5f84\u662f\u5426\u5b58\u5728\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    public NodeCache registerNodeCacheListener(ZookeeperNodeUpdateListener listener, String nodePath) {
        try {
            NodeCache nodeCache = new NodeCache(curator, nodePath);
            nodeCache.getListenable().addListener(() -> {
                ChildData childData = nodeCache.getCurrentData();
                if (childData != null) {
                    byte[] data = childData.getData();
                    listener.receive(data == null ? "" : new String(data, "UTF-8"));
                }
            });
            nodeCache.start();
            return nodeCache;
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormat.format("\u6ce8\u518c\u8282\u70b9\u76d1\u542c\u5668\u51fa\u73b0\u5f02\u5e38,nodePath:{0}", nodePath), e);
        }
    }

    public void updateNodeValue(String nodePath, String nodeValue) {
        try {
            curator.setData().forPath(nodePath, nodeValue.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException("\u66f4\u65b0\u6570\u636e\u5931\u8d25", e);
        }
    }

    public String lookupDataStr(String nodePath) {
        try {
            byte[] bytes = (byte[])curator.getData().forPath(nodePath);
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u8282\u70b9\u6570\u636e\u5931\u8d25", e);
        }
    }
}

