package com.xforceplus.bi.ultraman.binlog.handler;

import com.alibaba.fastjson.JSON;
import com.xforceplus.bi.ultraman.binlog.pojo.BinlogPositionEntity;
import com.xforceplus.bi.ultraman.binlog.pojo.DatabaseInfo;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultPositionHandler implements PositionHandler<BinlogPositionEntity> {
    private Map<String, String> cache = new ConcurrentHashMap<>();

    @Override
    public BinlogPositionEntity getPosition(DatabaseInfo databaseInfo) {
        return JSON.parseObject(cache.get(generateKey(databaseInfo)), BinlogPositionEntity.class);
    }

    @Override
    public void savePosition(DatabaseInfo databaseInfo, BinlogPositionEntity binlogPositionEntity) {
        cache.put(generateKey(databaseInfo), JSON.toJSONString(binlogPositionEntity));
    }

    @Override
    public void clear(DatabaseInfo databaseInfo) {
        cache.remove(generateKey(databaseInfo));
    }

    private String generateKey(DatabaseInfo databaseInfo) {
        return databaseInfo.getHostname() + ":" + databaseInfo.getPort();
    }
}
