package com.xforceplus.bi.ultraman.binlog.handler;

import com.xforceplus.bi.ultraman.binlog.pojo.DatabaseInfo;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

@Slf4j
@AllArgsConstructor
public class RedisGTIDHandler implements PositionHandler<String> {
    private RedissonClient redissonClient;

    @Override
    public String getPosition(DatabaseInfo databaseInfo) {
        RBucket<Object> bucket = redissonClient.getBucket(genKey(databaseInfo));
        return (String) bucket.get();
    }

    @Override
    public void savePosition(DatabaseInfo databaseInfo, String position) {
        RLock lock = redissonClient.getLock(genKey(databaseInfo) + "_lock");
        lock.lock();
        if (lock.isLocked()) {
            try {
                RBucket<Object> bucket = redissonClient.getBucket(genKey(databaseInfo));
                bucket.set(position);
//                log.debug(position);
            } catch (Exception e) {
                throw e;
            } finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void clear(DatabaseInfo databaseInfo) {
        RBucket<Object> bucket = redissonClient.getBucket(genKey(databaseInfo));
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    private String genKey(DatabaseInfo databaseInfo) {
        return "xforce_bi:ultraman_binlog:gtid:"
                + databaseInfo.getHostname().replaceAll(":", "").replaceAll(".", "")
                + "_"
                + databaseInfo.getPort();
    }
}
