package com.xforceplus.bi.ultraman.binlog.handler;

import com.xforceplus.bi.ultraman.binlog.pojo.BinlogPositionEntity;
import com.xforceplus.bi.ultraman.binlog.pojo.DatabaseInfo;
import lombok.AllArgsConstructor;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

@AllArgsConstructor
public class RedisPositionHandler implements PositionHandler<BinlogPositionEntity> {
    private RedissonClient redissonClient;

    @Override
    public BinlogPositionEntity getPosition(DatabaseInfo databaseInfo) {
        RBucket<Object> bucket = redissonClient.getBucket(genKey(databaseInfo));
        return (BinlogPositionEntity) bucket.get();
    }

    @Override
    public void savePosition(DatabaseInfo databaseInfo, BinlogPositionEntity binlogPositionEntity) {
        RLock lock = redissonClient.getLock(genKey(databaseInfo) + "_lock");
        lock.lock();
        if (lock.isLocked()) {
            try {
                RBucket<Object> bucket = redissonClient.getBucket(genKey(databaseInfo));
                bucket.set(binlogPositionEntity);
            } catch (Exception e) {
                throw e;
            } finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void clear(DatabaseInfo databaseInfo) {
        RBucket<Object> bucket = redissonClient.getBucket(genKey(databaseInfo));
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    private String genKey(DatabaseInfo databaseInfo) {
        return "xforce_bi:ultraman_binlog:position:"
                + databaseInfo.getHostname().replaceAll(":", "").replaceAll(".", "")
                + "_"
                + databaseInfo.getPort();
    }
}
