/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.ultraman.binlog;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.GtidSet;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.google.common.collect.Lists;
import com.xforceplus.bi.ultraman.binlog.CDCException;
import com.xforceplus.bi.ultraman.binlog.LifeCycleCDC;
import com.xforceplus.bi.ultraman.binlog.handler.CDCBusinessHandler;
import com.xforceplus.bi.ultraman.binlog.handler.PositionHandler;
import com.xforceplus.bi.ultraman.binlog.pojo.BinlogPositionEntity;
import com.xforceplus.bi.ultraman.binlog.pojo.DatabaseInfo;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLBinaryLogCDC
implements LifeCycleCDC {
    private static final Logger log = LoggerFactory.getLogger(MySQLBinaryLogCDC.class);
    private List<CDCBusinessHandler> cdcBusinessHandlers = Lists.newArrayList();
    private DatabaseInfo databaseInfo;
    private PositionHandler positionHandler;
    private boolean useGTID;
    private GtidSet gtidSet;
    private BinaryLogClient client;
    private BinaryLogClient.EventListener eventListener;
    private BinaryLogClient.LifecycleListener lifecycleListener;

    public MySQLBinaryLogCDC(DatabaseInfo databaseInfo, PositionHandler positionHandler, boolean useGTID) {
        this.databaseInfo = databaseInfo;
        this.positionHandler = positionHandler;
        this.useGTID = useGTID;
    }

    public void addCDCEventHandler(CDCBusinessHandler cdcBusinessHandler) {
        if (this.client != null && this.client.isConnected()) {
            log.error("{} has started, cannot add new CDCEventHandler into it", (Object)this.getClass().getSimpleName());
            return;
        }
        this.cdcBusinessHandlers.add(cdcBusinessHandler);
    }

    @Override
    public void start() throws Exception {
        if (this.isStarted()) {
            log.warn("{} has already started, do not do it again", (Object)this.getClass().getSimpleName());
            return;
        }
        this.client = this.createBinlogClient();
        this.client.setEventDeserializer(new EventDeserializer());
        this.client.setServerId(this.getRandomServerId());
        Object position = this.positionHandler.getPosition(this.databaseInfo);
        if (this.useGTID) {
            this.client.setGtidSet(position == null ? "" : (String)position);
            this.client.setGtidSetFallbackToPurged(true);
            this.gtidSet = new GtidSet(this.client.getGtidSet());
            log.info("Now gtid is {}", (Object)this.client.getGtidSet());
        } else {
            BinlogPositionEntity binlogPositionEntity = (BinlogPositionEntity)position;
            if (binlogPositionEntity != null && binlogPositionEntity.getBinlogName() != null && binlogPositionEntity.getPosition() != null) {
                this.client.setBinlogFilename(binlogPositionEntity.getBinlogName());
                this.client.setBinlogPosition(binlogPositionEntity.getPosition().longValue());
                log.info("Set binlog position = {}", (Object)binlogPositionEntity.getPosition());
            }
            log.info("Now position is {}, {}", (Object)this.client.getBinlogFilename(), (Object)this.client.getBinlogPosition());
        }
        this.eventListener = this.createBinlogEventListener();
        this.client.registerEventListener(this.eventListener);
        this.lifecycleListener = this.createBinlogLifecycleListener();
        this.client.registerLifecycleListener(this.lifecycleListener);
        this.client.connect();
    }

    private long getRandomServerId() {
        try {
            return SecureRandom.getInstanceStrong().nextLong();
        }
        catch (NoSuchAlgorithmException e) {
            return RandomUtils.nextLong();
        }
    }

    private BinaryLogClient createBinlogClient() {
        BinaryLogClient client = new BinaryLogClient(this.databaseInfo.getHostname(), this.databaseInfo.getPort(), this.databaseInfo.getUsername(), this.databaseInfo.getPassword());
        return client;
    }

    private BinaryLogClient.EventListener createBinlogEventListener() {
        return event -> {
            EventHeaderV4 header = (EventHeaderV4)event.getHeader();
            if (header.getEventType() == EventType.FORMAT_DESCRIPTION || header.getEventType() == EventType.HEARTBEAT) {
                return;
            }
            if (this.useGTID) {
                if (header.getEventType() == EventType.GTID) {
                    GtidEventData gtidEventData = (GtidEventData)event.getData();
                    this.gtidSet.add(gtidEventData.getGtid());
                    this.positionHandler.savePosition(this.databaseInfo, this.gtidSet.toString());
                }
            } else {
                BinlogPositionEntity binlogPositionEntity = new BinlogPositionEntity();
                if (header.getEventType().equals((Object)EventType.ROTATE)) {
                    RotateEventData rotateEventData = (RotateEventData)event.getData();
                    binlogPositionEntity.setBinlogName(rotateEventData.getBinlogFilename());
                    binlogPositionEntity.setPosition(rotateEventData.getBinlogPosition());
                } else {
                    binlogPositionEntity = (BinlogPositionEntity)this.positionHandler.getPosition(this.databaseInfo);
                    binlogPositionEntity.setPosition(header.getPosition());
                }
                binlogPositionEntity.setServerId(header.getServerId());
                this.positionHandler.savePosition(this.databaseInfo, binlogPositionEntity);
            }
            this.cdcBusinessHandlers.forEach(handler -> handler.handle(event));
        };
    }

    private BinaryLogClient.LifecycleListener createBinlogLifecycleListener() {
        return new BinaryLogClient.LifecycleListener(){

            public void onConnect(BinaryLogClient client) {
                log.info("Successfully connect to the mysql server");
            }

            public void onCommunicationFailure(BinaryLogClient client, Exception ex) {
                log.error("Communication Failure", (Throwable)ex);
                MySQLBinaryLogCDC.this.positionHandler.clear(MySQLBinaryLogCDC.this.databaseInfo);
                try {
                    MySQLBinaryLogCDC.this.stop();
                }
                catch (Exception e) {
                    log.error("Fatal to stop binlog listener", (Throwable)e);
                }
                try {
                    MySQLBinaryLogCDC.this.start();
                }
                catch (Exception e) {
                    log.error("Fatal to start binlog listener", (Throwable)e);
                }
                log.info("position is clean and binlog listener is restarted");
            }

            public void onEventDeserializationFailure(BinaryLogClient client, Exception ex) {
                log.error("Event Deserialization Failure", (Throwable)ex);
            }

            public void onDisconnect(BinaryLogClient client) {
                log.info("Disconnect from the mysql server");
            }
        };
    }

    @Override
    public void stop() throws Exception {
        try {
            if (this.eventListener != null && this.client != null) {
                this.client.unregisterEventListener(this.eventListener);
            }
            if (this.lifecycleListener != null && this.client != null) {
                this.client.unregisterLifecycleListener(this.lifecycleListener);
            }
            this.client = null;
            this.eventListener = null;
            this.lifecycleListener = null;
            log.info("MySQLBinaryLogCDC stopped...");
        }
        catch (Throwable throwable) {
            throw new CDCException("Error closing MySQL Binlog CDC connection");
        }
    }

    @Override
    public boolean isStarted() {
        return this.client != null && this.client.isConnected();
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }
}

