/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.ultraman.binlog.handler;

import com.xforceplus.bi.ultraman.binlog.handler.PositionHandler;
import com.xforceplus.bi.ultraman.binlog.pojo.DatabaseInfo;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisGTIDHandler
implements PositionHandler<String> {
    private static final Logger log = LoggerFactory.getLogger(RedisGTIDHandler.class);
    private RedissonClient redissonClient;

    @Override
    public String getPosition(DatabaseInfo databaseInfo) {
        RBucket bucket = this.redissonClient.getBucket(this.genKey(databaseInfo));
        return (String)bucket.get();
    }

    @Override
    public void savePosition(DatabaseInfo databaseInfo, String position) {
        RLock lock = this.redissonClient.getLock(this.genKey(databaseInfo) + "_lock");
        lock.lock();
        if (lock.isLocked()) {
            try {
                RBucket bucket = this.redissonClient.getBucket(this.genKey(databaseInfo));
                bucket.set((Object)position);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void clear(DatabaseInfo databaseInfo) {
        RBucket bucket = this.redissonClient.getBucket(this.genKey(databaseInfo));
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    private String genKey(DatabaseInfo databaseInfo) {
        return "xforce_bi:ultraman_binlog:gtid:" + databaseInfo.getHostname().replaceAll(":", "").replaceAll(".", "") + "_" + databaseInfo.getPort();
    }

    public RedisGTIDHandler(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

