/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.ultraman.binlog.handler;

import com.xforceplus.bi.ultraman.binlog.handler.PositionHandler;
import com.xforceplus.bi.ultraman.binlog.pojo.BinlogPositionEntity;
import com.xforceplus.bi.ultraman.binlog.pojo.DatabaseInfo;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class RedisPositionHandler
implements PositionHandler<BinlogPositionEntity> {
    private RedissonClient redissonClient;

    @Override
    public BinlogPositionEntity getPosition(DatabaseInfo databaseInfo) {
        RBucket bucket = this.redissonClient.getBucket(this.genKey(databaseInfo));
        return (BinlogPositionEntity)bucket.get();
    }

    @Override
    public void savePosition(DatabaseInfo databaseInfo, BinlogPositionEntity binlogPositionEntity) {
        RLock lock = this.redissonClient.getLock(this.genKey(databaseInfo) + "_lock");
        lock.lock();
        if (lock.isLocked()) {
            try {
                RBucket bucket = this.redissonClient.getBucket(this.genKey(databaseInfo));
                bucket.set((Object)binlogPositionEntity);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void clear(DatabaseInfo databaseInfo) {
        RBucket bucket = this.redissonClient.getBucket(this.genKey(databaseInfo));
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    private String genKey(DatabaseInfo databaseInfo) {
        return "xforce_bi:ultraman_binlog:position:" + databaseInfo.getHostname().replaceAll(":", "").replaceAll(".", "") + "_" + databaseInfo.getPort();
    }

    public RedisPositionHandler(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

