package com.xforceplus.bi.ultraman.dictionaries.bean;

import lombok.*;

import java.util.List;

/**
 * @ClassName DictMsgBean
 * @Deacription 字典消息类
 * @Author ligang
 * @Date 2020/9/7 14:46
 * @Version 1.0
 **/
@AllArgsConstructor
@NoArgsConstructor
@Builder(toBuilder = true)
@Data
public class DictMsgBean {

    /**
     * id : 1296468447404982273
     * code : status
     * name : 状态
     * appId : 1
     * version : 1.0.0
     * options : [{"id":"1296468447417565186","value":"0","text":"生效"},{"id":"1296468447430148097","value":"1","text":"未生效"}]
     */

    private String id;
    private String code;
    private String name;
    private String version;
    /**
     * id : 1296468447417565186
     * value : 0
     * text : 生效
     */
    @Singular
    private List<OptionsBean> options;

    @AllArgsConstructor
    @NoArgsConstructor
    @Builder(toBuilder = true)
    @Data
    public static class OptionsBean {
        private String id;
        private String value;
        private String text;
    }
}
