/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.ultraman.dictionaries.service.impl;

import com.xforceplus.bi.ultraman.dictionaries.bean.DictMsgBean;
import com.xforceplus.bi.ultraman.dictionaries.service.DictServiceInterface;
import com.xforceplus.bi.ultraman.utils.EntityNameUtil;
import com.xforceplus.bi.ultraman.utils.bean.EntityType;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictServiceInterfaceImpl
implements DictServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DictServiceInterfaceImpl.class);
    @Autowired
    private DSLContext dslContext;

    @Override
    @Transactional(value="greenplumnTransactionManager", rollbackFor={Exception.class})
    public void modifyDictDatas(DictMsgBean dictMsgBean) {
        Table<Record> table = this.getRecordTable(dictMsgBean);
        if (this.existaTable(table)) {
            this.deleteDictTable(dictMsgBean);
            log.info("\u5220\u9664\u5b57\u5178\u8868\u6570\u636e({})", (Object)table.getName());
        } else {
            this.createDictTable(dictMsgBean.getName(), table);
            log.info("\u521b\u5efa\u5b57\u5178\u8868({})", (Object)table.getName());
        }
        log.info("\u63d2\u5165\u5b57\u5178\u8868\u6570\u636e({}) start", (Object)table.getName());
        this.insertDictValues(table, dictMsgBean.getOptions());
        log.info("\u63d2\u5165\u5b57\u5178\u8868\u6570\u636e({}) end", (Object)table.getName());
    }

    public boolean existaTable(Table<Record> table) {
        try {
            this.dslContext.fetchExists(table);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void deleteDictTable(DictMsgBean dictMsgBean) {
        this.dslContext.deleteFrom(this.getRecordTable(dictMsgBean)).execute();
    }

    private void createDictTable(String tableComment, Table<Record> table) {
        this.dslContext.createTable(table).column("id", SQLDataType.VARCHAR((int)100).nullable(false)).column("value", SQLDataType.VARCHAR((int)256).nullable(false)).column("text", SQLDataType.VARCHAR((int)256).nullable(false)).execute();
        String tableName = table.getName();
        this.dslContext.commentOnTable(table).is(tableComment).execute();
        this.dslContext.commentOnColumn(DSL.field((String)(tableName + ".id"))).is("\u5b57\u5178ID").execute();
        this.dslContext.commentOnColumn(DSL.field((String)(tableName + ".value"))).is("\u5b57\u5178\u503c").execute();
        this.dslContext.commentOnColumn(DSL.field((String)(tableName + ".text"))).is("\u5b57\u5178\u503c\u63cf\u8ff0").execute();
    }

    private void insertDictValues(Table<Record> table, List<DictMsgBean.OptionsBean> options) {
        for (DictMsgBean.OptionsBean option : options) {
            this.dslContext.insertInto(table).columns(DSL.field((String)"id"), DSL.field((String)"value"), DSL.field((String)"text")).values((Object)option.getId(), (Object)option.getValue(), (Object)option.getText()).execute();
            log.info("\u63d2\u5165\u6570\u636e(id={},value={},text={})", new Object[]{option.getId(), option.getValue(), option.getText()});
        }
    }

    private Table<Record> getRecordTable(DictMsgBean dictMsgBean) {
        Table table = DSL.table((String)EntityNameUtil.tableNameConvert((String)dictMsgBean.getId(), (EntityType)EntityType.DICT, (String)dictMsgBean.getCode()));
        return table;
    }
}

