package com.xforceplus.bill.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据状态
 * </p>
 *
 * @author ultraman
 * @since 2021-05-08
 */
public enum BillStatus {

    DSF("dsf", "sdf");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillStatus fromCode(String code){
        switch(code) {
            case "dsf":
                return DSF;
            default:
                return null;
        }
    }
}
