package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdAutoSalesbill;
import com.xforceplus.unifymaintenanceproject.service.IOrdAutoSalesbillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdAutoSalesbillController {

  @Autowired
  private IOrdAutoSalesbillService ordAutoSalesbillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordAutoSalesbill ${table.comment}
   * @return
   */
  @GetMapping("/ordautosalesbills" )
  public XfR getOrdAutoSalesbills(XfPage page, OrdAutoSalesbill ordAutoSalesbill) {
    return XfR.ok(ordAutoSalesbillServiceImpl.page(page, Wrappers.query(ordAutoSalesbill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordautosalesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordAutoSalesbillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordAutoSalesbill ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordautosalesbills")
  public XfR save(@RequestBody OrdAutoSalesbill ordAutoSalesbill) {
     return XfR.ok(ordAutoSalesbillServiceImpl.save(ordAutoSalesbill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordAutoSalesbill ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordautosalesbills/{id}")
  public XfR putUpdate(@RequestBody OrdAutoSalesbill ordAutoSalesbill,@PathVariable Long id) {
      ordAutoSalesbill.setId(id);
      return XfR.ok(ordAutoSalesbillServiceImpl.updateById(ordAutoSalesbill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordAutoSalesbill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordautosalesbills/{id}")
  public XfR patchUpdate(@RequestBody OrdAutoSalesbill ordAutoSalesbill,@PathVariable Long id) {
      OrdAutoSalesbill upordAutoSalesbill = ordAutoSalesbillServiceImpl.getById(id);
      if(upordAutoSalesbill != null){
        upordAutoSalesbill = ObjectCopyUtils.copyProperties(ordAutoSalesbill,upordAutoSalesbill,true);
      }
      return XfR.ok(ordAutoSalesbillServiceImpl.updateById(upordAutoSalesbill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordautosalesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordAutoSalesbillServiceImpl.removeById(id));
  }

  @PostMapping("/ordautosalesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordautosalesbill");
      params.put("request", condition);

     return XfR.ok(ordAutoSalesbillServiceImpl.querys(params));
  }

}
