package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdAutoSalesbillItem;
import com.xforceplus.unifymaintenanceproject.service.IOrdAutoSalesbillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdAutoSalesbillItemController {

  @Autowired
  private IOrdAutoSalesbillItemService ordAutoSalesbillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordAutoSalesbillItem ${table.comment}
   * @return
   */
  @GetMapping("/ordautosalesbillitems" )
  public XfR getOrdAutoSalesbillItems(XfPage page, OrdAutoSalesbillItem ordAutoSalesbillItem) {
    return XfR.ok(ordAutoSalesbillItemServiceImpl.page(page, Wrappers.query(ordAutoSalesbillItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordautosalesbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordAutoSalesbillItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordAutoSalesbillItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordautosalesbillitems")
  public XfR save(@RequestBody OrdAutoSalesbillItem ordAutoSalesbillItem) {
     return XfR.ok(ordAutoSalesbillItemServiceImpl.save(ordAutoSalesbillItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordAutoSalesbillItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordautosalesbillitems/{id}")
  public XfR putUpdate(@RequestBody OrdAutoSalesbillItem ordAutoSalesbillItem,@PathVariable Long id) {
      ordAutoSalesbillItem.setId(id);
      return XfR.ok(ordAutoSalesbillItemServiceImpl.updateById(ordAutoSalesbillItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordAutoSalesbillItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordautosalesbillitems/{id}")
  public XfR patchUpdate(@RequestBody OrdAutoSalesbillItem ordAutoSalesbillItem,@PathVariable Long id) {
      OrdAutoSalesbillItem upordAutoSalesbillItem = ordAutoSalesbillItemServiceImpl.getById(id);
      if(upordAutoSalesbillItem != null){
        upordAutoSalesbillItem = ObjectCopyUtils.copyProperties(ordAutoSalesbillItem,upordAutoSalesbillItem,true);
      }
      return XfR.ok(ordAutoSalesbillItemServiceImpl.updateById(upordAutoSalesbillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordautosalesbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordAutoSalesbillItemServiceImpl.removeById(id));
  }

  @PostMapping("/ordautosalesbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordautosalesbillitem");
      params.put("request", condition);

     return XfR.ok(ordAutoSalesbillItemServiceImpl.querys(params));
  }

}
