package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdAutoSalesbillItemRalation;
import com.xforceplus.unifymaintenanceproject.service.IOrdAutoSalesbillItemRalationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdAutoSalesbillItemRalationController {

  @Autowired
  private IOrdAutoSalesbillItemRalationService ordAutoSalesbillItemRalationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordAutoSalesbillItemRalation ${table.comment}
   * @return
   */
  @GetMapping("/ordautosalesbillitemralations" )
  public XfR getOrdAutoSalesbillItemRalations(XfPage page, OrdAutoSalesbillItemRalation ordAutoSalesbillItemRalation) {
    return XfR.ok(ordAutoSalesbillItemRalationServiceImpl.page(page, Wrappers.query(ordAutoSalesbillItemRalation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordautosalesbillitemralations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordAutoSalesbillItemRalationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordAutoSalesbillItemRalation ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordautosalesbillitemralations")
  public XfR save(@RequestBody OrdAutoSalesbillItemRalation ordAutoSalesbillItemRalation) {
     return XfR.ok(ordAutoSalesbillItemRalationServiceImpl.save(ordAutoSalesbillItemRalation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordAutoSalesbillItemRalation ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordautosalesbillitemralations/{id}")
  public XfR putUpdate(@RequestBody OrdAutoSalesbillItemRalation ordAutoSalesbillItemRalation,@PathVariable Long id) {
      ordAutoSalesbillItemRalation.setId(id);
      return XfR.ok(ordAutoSalesbillItemRalationServiceImpl.updateById(ordAutoSalesbillItemRalation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordAutoSalesbillItemRalation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordautosalesbillitemralations/{id}")
  public XfR patchUpdate(@RequestBody OrdAutoSalesbillItemRalation ordAutoSalesbillItemRalation,@PathVariable Long id) {
      OrdAutoSalesbillItemRalation upordAutoSalesbillItemRalation = ordAutoSalesbillItemRalationServiceImpl.getById(id);
      if(upordAutoSalesbillItemRalation != null){
        upordAutoSalesbillItemRalation = ObjectCopyUtils.copyProperties(ordAutoSalesbillItemRalation,upordAutoSalesbillItemRalation,true);
      }
      return XfR.ok(ordAutoSalesbillItemRalationServiceImpl.updateById(upordAutoSalesbillItemRalation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordautosalesbillitemralations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordAutoSalesbillItemRalationServiceImpl.removeById(id));
  }

  @PostMapping("/ordautosalesbillitemralations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordautosalesbillitemralation");
      params.put("request", condition);

     return XfR.ok(ordAutoSalesbillItemRalationServiceImpl.querys(params));
  }

}
