package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdAutoSplitPreinvoiceInterface;
import com.xforceplus.unifymaintenanceproject.service.IOrdAutoSplitPreinvoiceInterfaceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdAutoSplitPreinvoiceInterfaceController {

  @Autowired
  private IOrdAutoSplitPreinvoiceInterfaceService ordAutoSplitPreinvoiceInterfaceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordAutoSplitPreinvoiceInterface ${table.comment}
   * @return
   */
  @GetMapping("/ordautosplitpreinvoiceinterfaces" )
  public XfR getOrdAutoSplitPreinvoiceInterfaces(XfPage page, OrdAutoSplitPreinvoiceInterface ordAutoSplitPreinvoiceInterface) {
    return XfR.ok(ordAutoSplitPreinvoiceInterfaceServiceImpl.page(page, Wrappers.query(ordAutoSplitPreinvoiceInterface)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordautosplitpreinvoiceinterfaces/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordAutoSplitPreinvoiceInterfaceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordAutoSplitPreinvoiceInterface ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordautosplitpreinvoiceinterfaces")
  public XfR save(@RequestBody OrdAutoSplitPreinvoiceInterface ordAutoSplitPreinvoiceInterface) {
     return XfR.ok(ordAutoSplitPreinvoiceInterfaceServiceImpl.save(ordAutoSplitPreinvoiceInterface));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordAutoSplitPreinvoiceInterface ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordautosplitpreinvoiceinterfaces/{id}")
  public XfR putUpdate(@RequestBody OrdAutoSplitPreinvoiceInterface ordAutoSplitPreinvoiceInterface,@PathVariable Long id) {
      ordAutoSplitPreinvoiceInterface.setId(id);
      return XfR.ok(ordAutoSplitPreinvoiceInterfaceServiceImpl.updateById(ordAutoSplitPreinvoiceInterface));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordAutoSplitPreinvoiceInterface ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordautosplitpreinvoiceinterfaces/{id}")
  public XfR patchUpdate(@RequestBody OrdAutoSplitPreinvoiceInterface ordAutoSplitPreinvoiceInterface,@PathVariable Long id) {
      OrdAutoSplitPreinvoiceInterface upordAutoSplitPreinvoiceInterface = ordAutoSplitPreinvoiceInterfaceServiceImpl.getById(id);
      if(upordAutoSplitPreinvoiceInterface != null){
        upordAutoSplitPreinvoiceInterface = ObjectCopyUtils.copyProperties(ordAutoSplitPreinvoiceInterface,upordAutoSplitPreinvoiceInterface,true);
      }
      return XfR.ok(ordAutoSplitPreinvoiceInterfaceServiceImpl.updateById(upordAutoSplitPreinvoiceInterface));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordautosplitpreinvoiceinterfaces/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordAutoSplitPreinvoiceInterfaceServiceImpl.removeById(id));
  }

  @PostMapping("/ordautosplitpreinvoiceinterfaces/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordautosplitpreinvoiceinterface");
      params.put("request", condition);

     return XfR.ok(ordAutoSplitPreinvoiceInterfaceServiceImpl.querys(params));
  }

}
