package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbillAttachment;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillAttachmentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillAttachmentController {

  @Autowired
  private IOrdSalesbillAttachmentService ordSalesbillAttachmentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillAttachment ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbillattachments" )
  public XfR getOrdSalesbillAttachments(XfPage page, OrdSalesbillAttachment ordSalesbillAttachment) {
    return XfR.ok(ordSalesbillAttachmentServiceImpl.page(page, Wrappers.query(ordSalesbillAttachment)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillattachments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillAttachmentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbillAttachment ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbillattachments")
  public XfR save(@RequestBody OrdSalesbillAttachment ordSalesbillAttachment) {
     return XfR.ok(ordSalesbillAttachmentServiceImpl.save(ordSalesbillAttachment));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbillAttachment ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbillattachments/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillAttachment ordSalesbillAttachment,@PathVariable Long id) {
      ordSalesbillAttachment.setId(id);
      return XfR.ok(ordSalesbillAttachmentServiceImpl.updateById(ordSalesbillAttachment));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbillAttachment ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbillattachments/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillAttachment ordSalesbillAttachment,@PathVariable Long id) {
      OrdSalesbillAttachment upordSalesbillAttachment = ordSalesbillAttachmentServiceImpl.getById(id);
      if(upordSalesbillAttachment != null){
        upordSalesbillAttachment = ObjectCopyUtils.copyProperties(ordSalesbillAttachment,upordSalesbillAttachment,true);
      }
      return XfR.ok(ordSalesbillAttachmentServiceImpl.updateById(upordSalesbillAttachment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillattachments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillAttachmentServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillattachments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbillattachment");
      params.put("request", condition);

     return XfR.ok(ordSalesbillAttachmentServiceImpl.querys(params));
  }

}
