package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbillAutoSplitLog;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillAutoSplitLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillAutoSplitLogController {

  @Autowired
  private IOrdSalesbillAutoSplitLogService ordSalesbillAutoSplitLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillAutoSplitLog ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbillautosplitlogs" )
  public XfR getOrdSalesbillAutoSplitLogs(XfPage page, OrdSalesbillAutoSplitLog ordSalesbillAutoSplitLog) {
    return XfR.ok(ordSalesbillAutoSplitLogServiceImpl.page(page, Wrappers.query(ordSalesbillAutoSplitLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillautosplitlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillAutoSplitLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbillAutoSplitLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbillautosplitlogs")
  public XfR save(@RequestBody OrdSalesbillAutoSplitLog ordSalesbillAutoSplitLog) {
     return XfR.ok(ordSalesbillAutoSplitLogServiceImpl.save(ordSalesbillAutoSplitLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbillAutoSplitLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbillautosplitlogs/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillAutoSplitLog ordSalesbillAutoSplitLog,@PathVariable Long id) {
      ordSalesbillAutoSplitLog.setId(id);
      return XfR.ok(ordSalesbillAutoSplitLogServiceImpl.updateById(ordSalesbillAutoSplitLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbillAutoSplitLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbillautosplitlogs/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillAutoSplitLog ordSalesbillAutoSplitLog,@PathVariable Long id) {
      OrdSalesbillAutoSplitLog upordSalesbillAutoSplitLog = ordSalesbillAutoSplitLogServiceImpl.getById(id);
      if(upordSalesbillAutoSplitLog != null){
        upordSalesbillAutoSplitLog = ObjectCopyUtils.copyProperties(ordSalesbillAutoSplitLog,upordSalesbillAutoSplitLog,true);
      }
      return XfR.ok(ordSalesbillAutoSplitLogServiceImpl.updateById(upordSalesbillAutoSplitLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillautosplitlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillAutoSplitLogServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillautosplitlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbillautosplitlog");
      params.put("request", condition);

     return XfR.ok(ordSalesbillAutoSplitLogServiceImpl.querys(params));
  }

}
