package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbill;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillController {

  @Autowired
  private IOrdSalesbillService ordSalesbillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbill ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbills" )
  public XfR getOrdSalesbills(XfPage page, OrdSalesbill ordSalesbill) {
    return XfR.ok(ordSalesbillServiceImpl.page(page, Wrappers.query(ordSalesbill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbill ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbills")
  public XfR save(@RequestBody OrdSalesbill ordSalesbill) {
     return XfR.ok(ordSalesbillServiceImpl.save(ordSalesbill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbill ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbills/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbill ordSalesbill,@PathVariable Long id) {
      ordSalesbill.setId(id);
      return XfR.ok(ordSalesbillServiceImpl.updateById(ordSalesbill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbills/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbill ordSalesbill,@PathVariable Long id) {
      OrdSalesbill upordSalesbill = ordSalesbillServiceImpl.getById(id);
      if(upordSalesbill != null){
        upordSalesbill = ObjectCopyUtils.copyProperties(ordSalesbill,upordSalesbill,true);
      }
      return XfR.ok(ordSalesbillServiceImpl.updateById(upordSalesbill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbill");
      params.put("request", condition);

     return XfR.ok(ordSalesbillServiceImpl.querys(params));
  }

}
