package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbillHistory;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillHistoryController {

  @Autowired
  private IOrdSalesbillHistoryService ordSalesbillHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillHistory ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbillhistorys" )
  public XfR getOrdSalesbillHistorys(XfPage page, OrdSalesbillHistory ordSalesbillHistory) {
    return XfR.ok(ordSalesbillHistoryServiceImpl.page(page, Wrappers.query(ordSalesbillHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbillHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbillhistorys")
  public XfR save(@RequestBody OrdSalesbillHistory ordSalesbillHistory) {
     return XfR.ok(ordSalesbillHistoryServiceImpl.save(ordSalesbillHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbillHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbillhistorys/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillHistory ordSalesbillHistory,@PathVariable Long id) {
      ordSalesbillHistory.setId(id);
      return XfR.ok(ordSalesbillHistoryServiceImpl.updateById(ordSalesbillHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbillHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbillhistorys/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillHistory ordSalesbillHistory,@PathVariable Long id) {
      OrdSalesbillHistory upordSalesbillHistory = ordSalesbillHistoryServiceImpl.getById(id);
      if(upordSalesbillHistory != null){
        upordSalesbillHistory = ObjectCopyUtils.copyProperties(ordSalesbillHistory,upordSalesbillHistory,true);
      }
      return XfR.ok(ordSalesbillHistoryServiceImpl.updateById(upordSalesbillHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbillhistory");
      params.put("request", condition);

     return XfR.ok(ordSalesbillHistoryServiceImpl.querys(params));
  }

}
