package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbillInterface;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillInterfaceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillInterfaceController {

  @Autowired
  private IOrdSalesbillInterfaceService ordSalesbillInterfaceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillInterface ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbillinterfaces" )
  public XfR getOrdSalesbillInterfaces(XfPage page, OrdSalesbillInterface ordSalesbillInterface) {
    return XfR.ok(ordSalesbillInterfaceServiceImpl.page(page, Wrappers.query(ordSalesbillInterface)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillinterfaces/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillInterfaceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbillInterface ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbillinterfaces")
  public XfR save(@RequestBody OrdSalesbillInterface ordSalesbillInterface) {
     return XfR.ok(ordSalesbillInterfaceServiceImpl.save(ordSalesbillInterface));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbillInterface ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbillinterfaces/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillInterface ordSalesbillInterface,@PathVariable Long id) {
      ordSalesbillInterface.setId(id);
      return XfR.ok(ordSalesbillInterfaceServiceImpl.updateById(ordSalesbillInterface));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbillInterface ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbillinterfaces/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillInterface ordSalesbillInterface,@PathVariable Long id) {
      OrdSalesbillInterface upordSalesbillInterface = ordSalesbillInterfaceServiceImpl.getById(id);
      if(upordSalesbillInterface != null){
        upordSalesbillInterface = ObjectCopyUtils.copyProperties(ordSalesbillInterface,upordSalesbillInterface,true);
      }
      return XfR.ok(ordSalesbillInterfaceServiceImpl.updateById(upordSalesbillInterface));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillinterfaces/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillInterfaceServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillinterfaces/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbillinterface");
      params.put("request", condition);

     return XfR.ok(ordSalesbillInterfaceServiceImpl.querys(params));
  }

}
