package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbillInterfaceItem;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillInterfaceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillInterfaceItemController {

  @Autowired
  private IOrdSalesbillInterfaceItemService ordSalesbillInterfaceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillInterfaceItem ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbillinterfaceitems" )
  public XfR getOrdSalesbillInterfaceItems(XfPage page, OrdSalesbillInterfaceItem ordSalesbillInterfaceItem) {
    return XfR.ok(ordSalesbillInterfaceItemServiceImpl.page(page, Wrappers.query(ordSalesbillInterfaceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillinterfaceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillInterfaceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbillInterfaceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbillinterfaceitems")
  public XfR save(@RequestBody OrdSalesbillInterfaceItem ordSalesbillInterfaceItem) {
     return XfR.ok(ordSalesbillInterfaceItemServiceImpl.save(ordSalesbillInterfaceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbillInterfaceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbillinterfaceitems/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillInterfaceItem ordSalesbillInterfaceItem,@PathVariable Long id) {
      ordSalesbillInterfaceItem.setId(id);
      return XfR.ok(ordSalesbillInterfaceItemServiceImpl.updateById(ordSalesbillInterfaceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbillInterfaceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbillinterfaceitems/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillInterfaceItem ordSalesbillInterfaceItem,@PathVariable Long id) {
      OrdSalesbillInterfaceItem upordSalesbillInterfaceItem = ordSalesbillInterfaceItemServiceImpl.getById(id);
      if(upordSalesbillInterfaceItem != null){
        upordSalesbillInterfaceItem = ObjectCopyUtils.copyProperties(ordSalesbillInterfaceItem,upordSalesbillInterfaceItem,true);
      }
      return XfR.ok(ordSalesbillInterfaceItemServiceImpl.updateById(upordSalesbillInterfaceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillinterfaceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillInterfaceItemServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillinterfaceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbillinterfaceitem");
      params.put("request", condition);

     return XfR.ok(ordSalesbillInterfaceItemServiceImpl.querys(params));
  }

}
