package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbillItem;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillItemController {

  @Autowired
  private IOrdSalesbillItemService ordSalesbillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillItem ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbillitems" )
  public XfR getOrdSalesbillItems(XfPage page, OrdSalesbillItem ordSalesbillItem) {
    return XfR.ok(ordSalesbillItemServiceImpl.page(page, Wrappers.query(ordSalesbillItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbillItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbillitems")
  public XfR save(@RequestBody OrdSalesbillItem ordSalesbillItem) {
     return XfR.ok(ordSalesbillItemServiceImpl.save(ordSalesbillItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbillItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbillitems/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillItem ordSalesbillItem,@PathVariable Long id) {
      ordSalesbillItem.setId(id);
      return XfR.ok(ordSalesbillItemServiceImpl.updateById(ordSalesbillItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbillItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbillitems/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillItem ordSalesbillItem,@PathVariable Long id) {
      OrdSalesbillItem upordSalesbillItem = ordSalesbillItemServiceImpl.getById(id);
      if(upordSalesbillItem != null){
        upordSalesbillItem = ObjectCopyUtils.copyProperties(ordSalesbillItem,upordSalesbillItem,true);
      }
      return XfR.ok(ordSalesbillItemServiceImpl.updateById(upordSalesbillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillItemServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbillitem");
      params.put("request", condition);

     return XfR.ok(ordSalesbillItemServiceImpl.querys(params));
  }

}
