package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbillMatchedInvoice;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillMatchedInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillMatchedInvoiceController {

  @Autowired
  private IOrdSalesbillMatchedInvoiceService ordSalesbillMatchedInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillMatchedInvoice ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbillmatchedinvoices" )
  public XfR getOrdSalesbillMatchedInvoices(XfPage page, OrdSalesbillMatchedInvoice ordSalesbillMatchedInvoice) {
    return XfR.ok(ordSalesbillMatchedInvoiceServiceImpl.page(page, Wrappers.query(ordSalesbillMatchedInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillmatchedinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillMatchedInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbillMatchedInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbillmatchedinvoices")
  public XfR save(@RequestBody OrdSalesbillMatchedInvoice ordSalesbillMatchedInvoice) {
     return XfR.ok(ordSalesbillMatchedInvoiceServiceImpl.save(ordSalesbillMatchedInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbillMatchedInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbillmatchedinvoices/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillMatchedInvoice ordSalesbillMatchedInvoice,@PathVariable Long id) {
      ordSalesbillMatchedInvoice.setId(id);
      return XfR.ok(ordSalesbillMatchedInvoiceServiceImpl.updateById(ordSalesbillMatchedInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbillMatchedInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbillmatchedinvoices/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillMatchedInvoice ordSalesbillMatchedInvoice,@PathVariable Long id) {
      OrdSalesbillMatchedInvoice upordSalesbillMatchedInvoice = ordSalesbillMatchedInvoiceServiceImpl.getById(id);
      if(upordSalesbillMatchedInvoice != null){
        upordSalesbillMatchedInvoice = ObjectCopyUtils.copyProperties(ordSalesbillMatchedInvoice,upordSalesbillMatchedInvoice,true);
      }
      return XfR.ok(ordSalesbillMatchedInvoiceServiceImpl.updateById(upordSalesbillMatchedInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillmatchedinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillMatchedInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillmatchedinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbillmatchedinvoice");
      params.put("request", condition);

     return XfR.ok(ordSalesbillMatchedInvoiceServiceImpl.querys(params));
  }

}
