package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbillSourceRel;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillSourceRelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillSourceRelController {

  @Autowired
  private IOrdSalesbillSourceRelService ordSalesbillSourceRelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillSourceRel ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbillsourcerels" )
  public XfR getOrdSalesbillSourceRels(XfPage page, OrdSalesbillSourceRel ordSalesbillSourceRel) {
    return XfR.ok(ordSalesbillSourceRelServiceImpl.page(page, Wrappers.query(ordSalesbillSourceRel)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillsourcerels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillSourceRelServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbillSourceRel ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbillsourcerels")
  public XfR save(@RequestBody OrdSalesbillSourceRel ordSalesbillSourceRel) {
     return XfR.ok(ordSalesbillSourceRelServiceImpl.save(ordSalesbillSourceRel));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbillSourceRel ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbillsourcerels/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillSourceRel ordSalesbillSourceRel,@PathVariable Long id) {
      ordSalesbillSourceRel.setId(id);
      return XfR.ok(ordSalesbillSourceRelServiceImpl.updateById(ordSalesbillSourceRel));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbillSourceRel ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbillsourcerels/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillSourceRel ordSalesbillSourceRel,@PathVariable Long id) {
      OrdSalesbillSourceRel upordSalesbillSourceRel = ordSalesbillSourceRelServiceImpl.getById(id);
      if(upordSalesbillSourceRel != null){
        upordSalesbillSourceRel = ObjectCopyUtils.copyProperties(ordSalesbillSourceRel,upordSalesbillSourceRel,true);
      }
      return XfR.ok(ordSalesbillSourceRelServiceImpl.updateById(upordSalesbillSourceRel));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillsourcerels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillSourceRelServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillsourcerels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbillsourcerel");
      params.put("request", condition);

     return XfR.ok(ordSalesbillSourceRelServiceImpl.querys(params));
  }

}
