package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbillSourceRelOld;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillSourceRelOldService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillSourceRelOldController {

  @Autowired
  private IOrdSalesbillSourceRelOldService ordSalesbillSourceRelOldServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillSourceRelOld ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbillsourcerelolds" )
  public XfR getOrdSalesbillSourceRelOlds(XfPage page, OrdSalesbillSourceRelOld ordSalesbillSourceRelOld) {
    return XfR.ok(ordSalesbillSourceRelOldServiceImpl.page(page, Wrappers.query(ordSalesbillSourceRelOld)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillsourcerelolds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillSourceRelOldServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbillSourceRelOld ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbillsourcerelolds")
  public XfR save(@RequestBody OrdSalesbillSourceRelOld ordSalesbillSourceRelOld) {
     return XfR.ok(ordSalesbillSourceRelOldServiceImpl.save(ordSalesbillSourceRelOld));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbillSourceRelOld ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbillsourcerelolds/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillSourceRelOld ordSalesbillSourceRelOld,@PathVariable Long id) {
      ordSalesbillSourceRelOld.setId(id);
      return XfR.ok(ordSalesbillSourceRelOldServiceImpl.updateById(ordSalesbillSourceRelOld));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbillSourceRelOld ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbillsourcerelolds/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillSourceRelOld ordSalesbillSourceRelOld,@PathVariable Long id) {
      OrdSalesbillSourceRelOld upordSalesbillSourceRelOld = ordSalesbillSourceRelOldServiceImpl.getById(id);
      if(upordSalesbillSourceRelOld != null){
        upordSalesbillSourceRelOld = ObjectCopyUtils.copyProperties(ordSalesbillSourceRelOld,upordSalesbillSourceRelOld,true);
      }
      return XfR.ok(ordSalesbillSourceRelOldServiceImpl.updateById(upordSalesbillSourceRelOld));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillsourcerelolds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillSourceRelOldServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillsourcerelolds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbillsourcerelold");
      params.put("request", condition);

     return XfR.ok(ordSalesbillSourceRelOldServiceImpl.querys(params));
  }

}
