package com.xforceplus.unifymaintenanceproject.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unifymaintenanceproject.entity.OrdSalesbillSourceRollbackLog;
import com.xforceplus.unifymaintenanceproject.service.IOrdSalesbillSourceRollbackLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-09-14
 */
@RestController
public class OrdSalesbillSourceRollbackLogController {

  @Autowired
  private IOrdSalesbillSourceRollbackLogService ordSalesbillSourceRollbackLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillSourceRollbackLog ${table.comment}
   * @return
   */
  @GetMapping("/ordsalesbillsourcerollbacklogs" )
  public XfR getOrdSalesbillSourceRollbackLogs(XfPage page, OrdSalesbillSourceRollbackLog ordSalesbillSourceRollbackLog) {
    return XfR.ok(ordSalesbillSourceRollbackLogServiceImpl.page(page, Wrappers.query(ordSalesbillSourceRollbackLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillsourcerollbacklogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillSourceRollbackLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ordSalesbillSourceRollbackLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordsalesbillsourcerollbacklogs")
  public XfR save(@RequestBody OrdSalesbillSourceRollbackLog ordSalesbillSourceRollbackLog) {
     return XfR.ok(ordSalesbillSourceRollbackLogServiceImpl.save(ordSalesbillSourceRollbackLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ordSalesbillSourceRollbackLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordsalesbillsourcerollbacklogs/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillSourceRollbackLog ordSalesbillSourceRollbackLog,@PathVariable Long id) {
      ordSalesbillSourceRollbackLog.setId(id);
      return XfR.ok(ordSalesbillSourceRollbackLogServiceImpl.updateById(ordSalesbillSourceRollbackLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ordSalesbillSourceRollbackLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordsalesbillsourcerollbacklogs/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillSourceRollbackLog ordSalesbillSourceRollbackLog,@PathVariable Long id) {
      OrdSalesbillSourceRollbackLog upordSalesbillSourceRollbackLog = ordSalesbillSourceRollbackLogServiceImpl.getById(id);
      if(upordSalesbillSourceRollbackLog != null){
        upordSalesbillSourceRollbackLog = ObjectCopyUtils.copyProperties(ordSalesbillSourceRollbackLog,upordSalesbillSourceRollbackLog,true);
      }
      return XfR.ok(ordSalesbillSourceRollbackLogServiceImpl.updateById(upordSalesbillSourceRollbackLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillsourcerollbacklogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillSourceRollbackLogServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillsourcerollbacklogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordsalesbillsourcerollbacklog");
      params.put("request", condition);

     return XfR.ok(ordSalesbillSourceRollbackLogServiceImpl.querys(params));
  }

}
