package com.xforceplus.inputbilldemo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.inputbilldemo.entity.ImportDemo;
import com.xforceplus.inputbilldemo.service.IImportDemoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-10
 */
@RestController
public class ImportDemoController {

  @Autowired
  private IImportDemoService importDemoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importDemo ${table.comment}
   * @return
   */
  @GetMapping("/importdemos" )
  public XfR getImportDemos(XfPage page, ImportDemo importDemo) {
    return XfR.ok(importDemoServiceImpl.page(page, Wrappers.query(importDemo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/importdemos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importDemoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param importDemo ${table.comment}
   * @return XfR
   */
  @PostMapping("/importdemos")
  public XfR save(@RequestBody ImportDemo importDemo) {
     return XfR.ok(importDemoServiceImpl.save(importDemo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param importDemo ${table.comment}
   * @return XfR
   */
  @PutMapping("/importdemos/{id}")
  public XfR putUpdate(@RequestBody ImportDemo importDemo,@PathVariable Long id) {
      importDemo.setId(id);
      return XfR.ok(importDemoServiceImpl.updateById(importDemo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param importDemo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/importdemos/{id}")
  public XfR patchUpdate(@RequestBody ImportDemo importDemo,@PathVariable Long id) {
      ImportDemo upimportDemo = importDemoServiceImpl.getById(id);
      if(upimportDemo != null){
        upimportDemo = ObjectCopyUtils.copyProperties(importDemo,upimportDemo,true);
      }
      return XfR.ok(importDemoServiceImpl.updateById(upimportDemo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importdemos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importDemoServiceImpl.removeById(id));
  }

  @PostMapping("/importdemos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "importdemo");
      params.put("request", condition);

     return XfR.ok(importDemoServiceImpl.querys(params));
  }

}
