package com.xforceplus.inputbilldemo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.inputbilldemo.entity.InvoiceMC;
import com.xforceplus.inputbilldemo.service.IInvoiceMCService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-10
 */
@RestController
public class InvoiceMCController {

  @Autowired
  private IInvoiceMCService invoiceMCServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceMC ${table.comment}
   * @return
   */
  @GetMapping("/invoicemcs" )
  public XfR getInvoiceMCs(XfPage page, InvoiceMC invoiceMC) {
    return XfR.ok(invoiceMCServiceImpl.page(page, Wrappers.query(invoiceMC)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicemcs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceMCServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceMC ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicemcs")
  public XfR save(@RequestBody InvoiceMC invoiceMC) {
     return XfR.ok(invoiceMCServiceImpl.save(invoiceMC));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceMC ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicemcs/{id}")
  public XfR putUpdate(@RequestBody InvoiceMC invoiceMC,@PathVariable Long id) {
      invoiceMC.setId(id);
      return XfR.ok(invoiceMCServiceImpl.updateById(invoiceMC));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceMC ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicemcs/{id}")
  public XfR patchUpdate(@RequestBody InvoiceMC invoiceMC,@PathVariable Long id) {
      InvoiceMC upinvoiceMC = invoiceMCServiceImpl.getById(id);
      if(upinvoiceMC != null){
        upinvoiceMC = ObjectCopyUtils.copyProperties(invoiceMC,upinvoiceMC,true);
      }
      return XfR.ok(invoiceMCServiceImpl.updateById(upinvoiceMC));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicemcs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceMCServiceImpl.removeById(id));
  }

  @PostMapping("/invoicemcs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "invoicemc");
      params.put("request", condition);

     return XfR.ok(invoiceMCServiceImpl.querys(params));
  }

}
