package com.xforceplus.inputbilldemo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.inputbilldemo.entity.InvoicePYT;
import com.xforceplus.inputbilldemo.service.IInvoicePYTService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-10
 */
@RestController
public class InvoicePYTController {

  @Autowired
  private IInvoicePYTService invoicePYTServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoicePYT ${table.comment}
   * @return
   */
  @GetMapping("/invoicepyts" )
  public XfR getInvoicePYTs(XfPage page, InvoicePYT invoicePYT) {
    return XfR.ok(invoicePYTServiceImpl.page(page, Wrappers.query(invoicePYT)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicepyts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoicePYTServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoicePYT ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicepyts")
  public XfR save(@RequestBody InvoicePYT invoicePYT) {
     return XfR.ok(invoicePYTServiceImpl.save(invoicePYT));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoicePYT ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicepyts/{id}")
  public XfR putUpdate(@RequestBody InvoicePYT invoicePYT,@PathVariable Long id) {
      invoicePYT.setId(id);
      return XfR.ok(invoicePYTServiceImpl.updateById(invoicePYT));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoicePYT ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicepyts/{id}")
  public XfR patchUpdate(@RequestBody InvoicePYT invoicePYT,@PathVariable Long id) {
      InvoicePYT upinvoicePYT = invoicePYTServiceImpl.getById(id);
      if(upinvoicePYT != null){
        upinvoicePYT = ObjectCopyUtils.copyProperties(invoicePYT,upinvoicePYT,true);
      }
      return XfR.ok(invoicePYTServiceImpl.updateById(upinvoicePYT));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicepyts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoicePYTServiceImpl.removeById(id));
  }

  @PostMapping("/invoicepyts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "invoicepyt");
      params.put("request", condition);

     return XfR.ok(invoicePYTServiceImpl.querys(params));
  }

}
