package com.xforceplus.bill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.bill.entity.Detail;
import com.xforceplus.bill.service.IDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-29
 */
@RestController
public class DetailController {

  @Autowired
  private IDetailService detailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param detail ${table.comment}
   * @return
   */
  @GetMapping("/details" )
  public XfR getDetails(XfPage page, Detail detail) {
    return XfR.ok(detailServiceImpl.page(page, Wrappers.query(detail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/details/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(detailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param detail ${table.comment}
   * @return XfR
   */
  @PostMapping("/details")
  public XfR save(@RequestBody Detail detail) {
     return XfR.ok(detailServiceImpl.save(detail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param detail ${table.comment}
   * @return XfR
   */
  @PutMapping("/details/{id}")
  public XfR putUpdate(@RequestBody Detail detail,@PathVariable Long id) {
      detail.setId(id);
      return XfR.ok(detailServiceImpl.updateById(detail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param detail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/details/{id}")
  public XfR patchUpdate(@RequestBody Detail detail,@PathVariable Long id) {
      Detail updetail = detailServiceImpl.getById(id);
      if(updetail != null){
        updetail = ObjectCopyUtils.copyProperties(detail,updetail,true);
      }
      return XfR.ok(detailServiceImpl.updateById(updetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/details/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(detailServiceImpl.removeById(id));
  }

  @PostMapping("/details/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "detail");
     params.put("request", condition);

     return XfR.ok(detailServiceImpl.querys(params));
  }

}
