package com.xforceplus.bill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.bill.entity.Orders;
import com.xforceplus.bill.service.IOrdersService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-29
 */
@RestController
public class OrdersController {

  @Autowired
  private IOrdersService ordersServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orders ${table.comment}
   * @return
   */
  @GetMapping("/orderss" )
  public XfR getOrderss(XfPage page, Orders orders) {
    return XfR.ok(ordersServiceImpl.page(page, Wrappers.query(orders)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordersServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orders ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderss")
  public XfR save(@RequestBody Orders orders) {
     return XfR.ok(ordersServiceImpl.save(orders));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orders ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderss/{id}")
  public XfR putUpdate(@RequestBody Orders orders,@PathVariable Long id) {
      orders.setId(id);
      return XfR.ok(ordersServiceImpl.updateById(orders));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orders ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderss/{id}")
  public XfR patchUpdate(@RequestBody Orders orders,@PathVariable Long id) {
      Orders uporders = ordersServiceImpl.getById(id);
      if(uporders != null){
        uporders = ObjectCopyUtils.copyProperties(orders,uporders,true);
      }
      return XfR.ok(ordersServiceImpl.updateById(uporders));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordersServiceImpl.removeById(id));
  }

  @PostMapping("/orderss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orders");
     params.put("request", condition);

     return XfR.ok(ordersServiceImpl.querys(params));
  }

}
