/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.bill.entity.Customer;
import com.xforceplus.bill.service.ICustomerService;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CustomerController {
    @Autowired
    private ICustomerService customerServiceImpl;

    @GetMapping(value={"/customers"})
    public XfR getCustomers(XfPage page, Customer customer) {
        return XfR.ok((Object)this.customerServiceImpl.page((IPage)page, (Wrapper)Wrappers.query((Object)customer)));
    }

    @GetMapping(value={"/customers/{id}"})
    public XfR getById(@PathVariable Long id) {
        return XfR.ok((Object)this.customerServiceImpl.getById(id));
    }

    @PostMapping(value={"/customers"})
    public XfR save(@RequestBody Customer customer) {
        return XfR.ok((Object)this.customerServiceImpl.save(customer));
    }

    @PutMapping(value={"/customers/{id}"})
    public XfR putUpdate(@RequestBody Customer customer, @PathVariable Long id) {
        customer.setId(id);
        return XfR.ok((Object)this.customerServiceImpl.updateById(customer));
    }

    @PatchMapping(value={"/customers/{id}"})
    public XfR patchUpdate(@RequestBody Customer customer, @PathVariable Long id) {
        Customer upcustomer = (Customer)this.customerServiceImpl.getById(id);
        if (upcustomer != null) {
            upcustomer = (Customer)ObjectCopyUtils.copyProperties((Object)customer, (Object)upcustomer, (boolean)true);
        }
        return XfR.ok((Object)this.customerServiceImpl.updateById(upcustomer));
    }

    @DeleteMapping(value={"/customers/{id}"})
    public XfR removeById(@PathVariable Long id) {
        return XfR.ok((Object)this.customerServiceImpl.removeById(id));
    }

    @PostMapping(value={"/customers/query"})
    public XfR querys(@RequestBody ConditionQueryRequest condition) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", "customer");
        params.put("request", condition);
        return XfR.ok(this.customerServiceImpl.querys(params));
    }
}

