package com.xforceplus.branchtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.branchtest.entity.Bookcolor;
import com.xforceplus.branchtest.service.IBookcolorService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-09
 */
@RestController
public class BookcolorController {

  @Autowired
  private IBookcolorService bookcolorServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bookcolor ${table.comment}
   * @return
   */
  @GetMapping("/bookcolors" )
  public XfR getBookcolors(XfPage page, Bookcolor bookcolor) {
    return XfR.ok(bookcolorServiceImpl.page(page, Wrappers.query(bookcolor)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bookcolors/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bookcolorServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bookcolor ${table.comment}
   * @return XfR
   */
  @PostMapping("/bookcolors")
  public XfR save(@RequestBody Bookcolor bookcolor) {
     return XfR.ok(bookcolorServiceImpl.save(bookcolor));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bookcolor ${table.comment}
   * @return XfR
   */
  @PutMapping("/bookcolors/{id}")
  public XfR putUpdate(@RequestBody Bookcolor bookcolor,@PathVariable Long id) {
      bookcolor.setId(id);
      return XfR.ok(bookcolorServiceImpl.updateById(bookcolor));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bookcolor ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bookcolors/{id}")
  public XfR patchUpdate(@RequestBody Bookcolor bookcolor,@PathVariable Long id) {
      Bookcolor upbookcolor = bookcolorServiceImpl.getById(id);
      if(upbookcolor != null){
        upbookcolor = ObjectCopyUtils.copyProperties(bookcolor,upbookcolor,true);
      }
      return XfR.ok(bookcolorServiceImpl.updateById(upbookcolor));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bookcolors/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bookcolorServiceImpl.removeById(id));
  }

  @PostMapping("/bookcolors/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bookcolor");
     params.put("request", condition);

     return XfR.ok(bookcolorServiceImpl.querys(params));
  }

}
