package com.xforceplus.branchtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.branchtest.entity.Keytest;
import com.xforceplus.branchtest.service.IKeytestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-09
 */
@RestController
public class KeytestController {

  @Autowired
  private IKeytestService keytestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param keytest ${table.comment}
   * @return
   */
  @GetMapping("/keytests" )
  public XfR getKeytests(XfPage page, Keytest keytest) {
    return XfR.ok(keytestServiceImpl.page(page, Wrappers.query(keytest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/keytests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(keytestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param keytest ${table.comment}
   * @return XfR
   */
  @PostMapping("/keytests")
  public XfR save(@RequestBody Keytest keytest) {
     return XfR.ok(keytestServiceImpl.save(keytest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param keytest ${table.comment}
   * @return XfR
   */
  @PutMapping("/keytests/{id}")
  public XfR putUpdate(@RequestBody Keytest keytest,@PathVariable Long id) {
      keytest.setId(id);
      return XfR.ok(keytestServiceImpl.updateById(keytest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param keytest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/keytests/{id}")
  public XfR patchUpdate(@RequestBody Keytest keytest,@PathVariable Long id) {
      Keytest upkeytest = keytestServiceImpl.getById(id);
      if(upkeytest != null){
        upkeytest = ObjectCopyUtils.copyProperties(keytest,upkeytest,true);
      }
      return XfR.ok(keytestServiceImpl.updateById(upkeytest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/keytests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(keytestServiceImpl.removeById(id));
  }

  @PostMapping("/keytests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "keytest");
     params.put("request", condition);

     return XfR.ok(keytestServiceImpl.querys(params));
  }

}
