package com.xforceplus.branchtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.branchtest.entity.Mastertest1;
import com.xforceplus.branchtest.service.IMastertest1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-09
 */
@RestController
public class Mastertest1Controller {

  @Autowired
  private IMastertest1Service mastertest1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mastertest1 ${table.comment}
   * @return
   */
  @GetMapping("/mastertest1s" )
  public XfR getMastertest1s(XfPage page, Mastertest1 mastertest1) {
    return XfR.ok(mastertest1ServiceImpl.page(page, Wrappers.query(mastertest1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/mastertest1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mastertest1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param mastertest1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/mastertest1s")
  public XfR save(@RequestBody Mastertest1 mastertest1) {
     return XfR.ok(mastertest1ServiceImpl.save(mastertest1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param mastertest1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/mastertest1s/{id}")
  public XfR putUpdate(@RequestBody Mastertest1 mastertest1,@PathVariable Long id) {
      mastertest1.setId(id);
      return XfR.ok(mastertest1ServiceImpl.updateById(mastertest1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param mastertest1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/mastertest1s/{id}")
  public XfR patchUpdate(@RequestBody Mastertest1 mastertest1,@PathVariable Long id) {
      Mastertest1 upmastertest1 = mastertest1ServiceImpl.getById(id);
      if(upmastertest1 != null){
        upmastertest1 = ObjectCopyUtils.copyProperties(mastertest1,upmastertest1,true);
      }
      return XfR.ok(mastertest1ServiceImpl.updateById(upmastertest1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mastertest1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mastertest1ServiceImpl.removeById(id));
  }

  @PostMapping("/mastertest1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mastertest1");
     params.put("request", condition);

     return XfR.ok(mastertest1ServiceImpl.querys(params));
  }

}
