package com.xforceplus.branchtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.branchtest.entity.Tester;
import com.xforceplus.branchtest.service.ITesterService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-09
 */
@RestController
public class TesterController {

  @Autowired
  private ITesterService testerServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tester ${table.comment}
   * @return
   */
  @GetMapping("/testers" )
  public XfR getTesters(XfPage page, Tester tester) {
    return XfR.ok(testerServiceImpl.page(page, Wrappers.query(tester)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testerServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tester ${table.comment}
   * @return XfR
   */
  @PostMapping("/testers")
  public XfR save(@RequestBody Tester tester) {
     return XfR.ok(testerServiceImpl.save(tester));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tester ${table.comment}
   * @return XfR
   */
  @PutMapping("/testers/{id}")
  public XfR putUpdate(@RequestBody Tester tester,@PathVariable Long id) {
      tester.setId(id);
      return XfR.ok(testerServiceImpl.updateById(tester));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tester ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testers/{id}")
  public XfR patchUpdate(@RequestBody Tester tester,@PathVariable Long id) {
      Tester uptester = testerServiceImpl.getById(id);
      if(uptester != null){
        uptester = ObjectCopyUtils.copyProperties(tester,uptester,true);
      }
      return XfR.ok(testerServiceImpl.updateById(uptester));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testerServiceImpl.removeById(id));
  }

  @PostMapping("/testers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tester");
     params.put("request", condition);

     return XfR.ok(testerServiceImpl.querys(params));
  }

}
