package com.xforceplus.bwcjsettlement.controller;


/**
 * 用于前端视图配置feign客户端
 *
 * @author ultraman
 * @date 2025-04-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.bwcjsettlement.entity.BillConditionObj;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "bwcj-settlement")
public interface BillConditionObjFeignApi {

  /**
   * 通过id查询用于前端视图配置
   * @param  id
   * @return R
   */
  @GetMapping("/billConditionObj/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增用于前端视图配置
   * @param billConditionObj 用于前端视图配置
   * @return R
   */
  @PostMapping("/billConditionObj/add")
  public R save(@RequestBody BillConditionObj billConditionObj);

  /**
   * 修改用于前端视图配置
   * @param billConditionObj 用于前端视图配置
   * @return R
   */
  @PostMapping("/billConditionObj/update")
  public R updateById(@RequestBody BillConditionObj billConditionObj);

  /**
   * 通过id删除用于前端视图配置
   * @param  id
   * @return R
   */
  @DeleteMapping("/billConditionObj/del/{id}" )
  public R removeById(@PathVariable Long id);

}