package com.xforceplus.bwcjsettlement.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-04-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.bwcjsettlement.entity.BillReviewLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "bwcj-settlement")
public interface BillReviewLogFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/billReviewLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param billReviewLog ${table.comment}
   * @return R
   */
  @PostMapping("/billReviewLog/add")
  public R save(@RequestBody BillReviewLog billReviewLog);

  /**
   * 修改${table.comment}
   * @param billReviewLog ${table.comment}
   * @return R
   */
  @PostMapping("/billReviewLog/update")
  public R updateById(@RequestBody BillReviewLog billReviewLog);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/billReviewLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}