package com.xforceplus.bwcjsettlement.controller;


/**
 * 系统工作流流程实例对象feign客户端
 *
 * @author ultraman
 * @date 2025-04-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.bwcjsettlement.entity.SysFlowIns;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "bwcj-settlement")
public interface SysFlowInsFeignApi {

  /**
   * 通过id查询系统工作流流程实例对象
   * @param  id
   * @return R
   */
  @GetMapping("/sysFlowIns/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统工作流流程实例对象
   * @param sysFlowIns 系统工作流流程实例对象
   * @return R
   */
  @PostMapping("/sysFlowIns/add")
  public R save(@RequestBody SysFlowIns sysFlowIns);

  /**
   * 修改系统工作流流程实例对象
   * @param sysFlowIns 系统工作流流程实例对象
   * @return R
   */
  @PostMapping("/sysFlowIns/update")
  public R updateById(@RequestBody SysFlowIns sysFlowIns);

  /**
   * 通过id删除系统工作流流程实例对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/sysFlowIns/del/{id}" )
  public R removeById(@PathVariable Long id);

}