package com.xforceplus.bwcjsettlement.controller;


/**
 * 系统用户任务历史对象feign客户端
 *
 * @author ultraman
 * @date 2025-04-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.bwcjsettlement.entity.SysFlowTaskHis;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "bwcj-settlement")
public interface SysFlowTaskHisFeignApi {

  /**
   * 通过id查询系统用户任务历史对象
   * @param  id
   * @return R
   */
  @GetMapping("/sysFlowTaskHis/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统用户任务历史对象
   * @param sysFlowTaskHis 系统用户任务历史对象
   * @return R
   */
  @PostMapping("/sysFlowTaskHis/add")
  public R save(@RequestBody SysFlowTaskHis sysFlowTaskHis);

  /**
   * 修改系统用户任务历史对象
   * @param sysFlowTaskHis 系统用户任务历史对象
   * @return R
   */
  @PostMapping("/sysFlowTaskHis/update")
  public R updateById(@RequestBody SysFlowTaskHis sysFlowTaskHis);

  /**
   * 通过id删除系统用户任务历史对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/sysFlowTaskHis/del/{id}" )
  public R removeById(@PathVariable Long id);

}