package com.xforceplus.bwcjsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-27
 */
public enum BusinessStatus {

    已闭店("已闭店", "已闭店"),
    正式开业("正式开业", "正式开业"),
    已停业("已停业", "已停业"),
    待开业("待开业", "待开业"),
    装修中("装修中", "装修中"),
    设计中("设计中", "设计中"),
    待签约("待签约", "待签约"),
    取消("取消", "取消"),
    已取消("已取消", "已取消");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessStatus fromCode(String code){
        switch(code) {
            case "已闭店":
                return 已闭店;
            case "正式开业":
                return 正式开业;
            case "已停业":
                return 已停业;
            case "待开业":
                return 待开业;
            case "装修中":
                return 装修中;
            case "设计中":
                return 设计中;
            case "待签约":
                return 待签约;
            case "取消":
                return 取消;
            case "已取消":
                return 已取消;
            default:
                return null;
        }
    }
}
