package com.xforceplus.bwcjsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_item_review_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-27
 */
public enum BillItemReviewStatus {

    _1("1", "待审批"),
    _3("3", "审批通过"),
    _2("2", "审批驳回");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillItemReviewStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillItemReviewStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "3":
                return _3;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
