package com.xforceplus.bwcjsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-27
 */
public enum BusinessStatus {

    _1("1", "已闭店"),
    _2("2", "正式开业"),
    _3("3", "已停业"),
    _4("4", "待开业"),
    _5("5", "装修中"),
    _6("6", "设计中"),
    _7("7", "待签约"),
    _8("8", "取消"),
    _9("9", "已取消");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
