package com.xforceplus.bwcjsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.bwcjsettlement.entity.BillConditionObj;
import com.xforceplus.bwcjsettlement.service.IBillConditionObjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 用于前端视图配置前端控制器
 *
 * @author ultraman
 * @date 2025-04-17
 */
@RestController
public class BillConditionObjController {

  @Autowired
  private IBillConditionObjService billConditionObjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billConditionObj 用于前端视图配置
   * @return
   */
  @GetMapping("/billconditionobjs" )
  public XfR getBillConditionObjs(XfPage page, BillConditionObj billConditionObj) {
    return XfR.ok(billConditionObjServiceImpl.page(page, Wrappers.query(billConditionObj)));
  }

  /**
   * 通过id查询用于前端视图配置
   * @param  id
   * @return XfR
   */
  @GetMapping("/billconditionobjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billConditionObjServiceImpl.getById(id));
  }

  /**
   * 新增用于前端视图配置
   * @param billConditionObj 用于前端视图配置
   * @return XfR
   */
  @PostMapping("/billconditionobjs")
  public XfR save(@RequestBody BillConditionObj billConditionObj) {
     return XfR.ok(billConditionObjServiceImpl.save(billConditionObj));
  }

  /**
   * 修改-传入修改后的全部数据用于前端视图配置
   * @param billConditionObj 用于前端视图配置
   * @return XfR
   */
  @PutMapping("/billconditionobjs/{id}")
  public XfR putUpdate(@RequestBody BillConditionObj billConditionObj,@PathVariable Long id) {
      billConditionObj.setId(id);
      return XfR.ok(billConditionObjServiceImpl.updateById(billConditionObj));
  }

  /**
   * 修改-传入修改的数据用于前端视图配置
   * @param billConditionObj 用于前端视图配置
   * @return XfR
   */
  @PatchMapping("/billconditionobjs/{id}")
  public XfR patchUpdate(@RequestBody BillConditionObj billConditionObj,@PathVariable Long id) {
      BillConditionObj upbillConditionObj = billConditionObjServiceImpl.getById(id);
      if(upbillConditionObj != null){
        upbillConditionObj = ObjectCopyUtils.copyProperties(billConditionObj,upbillConditionObj,true);
      }
      return XfR.ok(billConditionObjServiceImpl.updateById(upbillConditionObj));
  }

  /**
   * 通过id删除用于前端视图配置
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billconditionobjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billConditionObjServiceImpl.removeById(id));
  }

  @PostMapping("/billconditionobjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_condition_obj");
     params.put("request", condition);

     return XfR.ok(billConditionObjServiceImpl.querys(params));
  }

}
