package com.xforceplus.bwcjsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.bwcjsettlement.entity.BillReviewLog;
import com.xforceplus.bwcjsettlement.service.IBillReviewLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-17
 */
@RestController
public class BillReviewLogController {

  @Autowired
  private IBillReviewLogService billReviewLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billReviewLog ${table.comment}
   * @return
   */
  @GetMapping("/billreviewlogs" )
  public XfR getBillReviewLogs(XfPage page, BillReviewLog billReviewLog) {
    return XfR.ok(billReviewLogServiceImpl.page(page, Wrappers.query(billReviewLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billreviewlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billReviewLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billReviewLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/billreviewlogs")
  public XfR save(@RequestBody BillReviewLog billReviewLog) {
     return XfR.ok(billReviewLogServiceImpl.save(billReviewLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billReviewLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/billreviewlogs/{id}")
  public XfR putUpdate(@RequestBody BillReviewLog billReviewLog,@PathVariable Long id) {
      billReviewLog.setId(id);
      return XfR.ok(billReviewLogServiceImpl.updateById(billReviewLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billReviewLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billreviewlogs/{id}")
  public XfR patchUpdate(@RequestBody BillReviewLog billReviewLog,@PathVariable Long id) {
      BillReviewLog upbillReviewLog = billReviewLogServiceImpl.getById(id);
      if(upbillReviewLog != null){
        upbillReviewLog = ObjectCopyUtils.copyProperties(billReviewLog,upbillReviewLog,true);
      }
      return XfR.ok(billReviewLogServiceImpl.updateById(upbillReviewLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billreviewlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billReviewLogServiceImpl.removeById(id));
  }

  @PostMapping("/billreviewlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_review_log");
     params.put("request", condition);

     return XfR.ok(billReviewLogServiceImpl.querys(params));
  }

}
