package com.xforceplus.bwcjsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.bwcjsettlement.entity.SysFlowInsVar;
import com.xforceplus.bwcjsettlement.service.ISysFlowInsVarService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统工作流程实例变量对象前端控制器
 *
 * @author ultraman
 * @date 2025-04-17
 */
@RestController
public class SysFlowInsVarController {

  @Autowired
  private ISysFlowInsVarService sysFlowInsVarServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sysFlowInsVar 系统工作流程实例变量对象
   * @return
   */
  @GetMapping("/sysflowinsvars" )
  public XfR getSysFlowInsVars(XfPage page, SysFlowInsVar sysFlowInsVar) {
    return XfR.ok(sysFlowInsVarServiceImpl.page(page, Wrappers.query(sysFlowInsVar)));
  }

  /**
   * 通过id查询系统工作流程实例变量对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/sysflowinsvars/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sysFlowInsVarServiceImpl.getById(id));
  }

  /**
   * 新增系统工作流程实例变量对象
   * @param sysFlowInsVar 系统工作流程实例变量对象
   * @return XfR
   */
  @PostMapping("/sysflowinsvars")
  public XfR save(@RequestBody SysFlowInsVar sysFlowInsVar) {
     return XfR.ok(sysFlowInsVarServiceImpl.save(sysFlowInsVar));
  }

  /**
   * 修改-传入修改后的全部数据系统工作流程实例变量对象
   * @param sysFlowInsVar 系统工作流程实例变量对象
   * @return XfR
   */
  @PutMapping("/sysflowinsvars/{id}")
  public XfR putUpdate(@RequestBody SysFlowInsVar sysFlowInsVar,@PathVariable Long id) {
      sysFlowInsVar.setId(id);
      return XfR.ok(sysFlowInsVarServiceImpl.updateById(sysFlowInsVar));
  }

  /**
   * 修改-传入修改的数据系统工作流程实例变量对象
   * @param sysFlowInsVar 系统工作流程实例变量对象
   * @return XfR
   */
  @PatchMapping("/sysflowinsvars/{id}")
  public XfR patchUpdate(@RequestBody SysFlowInsVar sysFlowInsVar,@PathVariable Long id) {
      SysFlowInsVar upsysFlowInsVar = sysFlowInsVarServiceImpl.getById(id);
      if(upsysFlowInsVar != null){
        upsysFlowInsVar = ObjectCopyUtils.copyProperties(sysFlowInsVar,upsysFlowInsVar,true);
      }
      return XfR.ok(sysFlowInsVarServiceImpl.updateById(upsysFlowInsVar));
  }

  /**
   * 通过id删除系统工作流程实例变量对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sysflowinsvars/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sysFlowInsVarServiceImpl.removeById(id));
  }

  @PostMapping("/sysflowinsvars/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sys_flow_ins_var");
     params.put("request", condition);

     return XfR.ok(sysFlowInsVarServiceImpl.querys(params));
  }

}
