package com.xforceplus.casservice.controller;


/**
 * 流程回放日志feign客户端
 *
 * @author ultraman
 * @date 2024-03-19
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.casservice.entity.FlowReplayLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "cas-service")
public interface FlowReplayLogFeignApi {

  /**
   * 通过id查询流程回放日志
   * @param  id
   * @return R
   */
  @GetMapping("/flowReplayLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增流程回放日志
   * @param flowReplayLog 流程回放日志
   * @return R
   */
  @PostMapping("/flowReplayLog/add")
  public R save(@RequestBody FlowReplayLog flowReplayLog);

  /**
   * 修改流程回放日志
   * @param flowReplayLog 流程回放日志
   * @return R
   */
  @PostMapping("/flowReplayLog/update")
  public R updateById(@RequestBody FlowReplayLog flowReplayLog);

  /**
   * 通过id删除流程回放日志
   * @param  id
   * @return R
   */
  @DeleteMapping("/flowReplayLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}