package com.xforceplus.casservice.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-03-19
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.casservice.entity.OrgSoldToParty;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "cas-service")
public interface OrgSoldToPartyFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/orgSoldToParty/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param orgSoldToParty ${table.comment}
   * @return R
   */
  @PostMapping("/orgSoldToParty/add")
  public R save(@RequestBody OrgSoldToParty orgSoldToParty);

  /**
   * 修改${table.comment}
   * @param orgSoldToParty ${table.comment}
   * @return R
   */
  @PostMapping("/orgSoldToParty/update")
  public R updateById(@RequestBody OrgSoldToParty orgSoldToParty);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/orgSoldToParty/del/{id}" )
  public R removeById(@PathVariable Long id);

}